//
//  GHLanguage.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 1/5/17.
//  Copyright © 2017 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 *  The language to use on the device. Avalable languages vary by devise.
 */
typedef NS_ENUM(NSInteger, GHLanguageId) { //maps to FIT_LANGUAGE
    /** English language  */
    GHEnglish = 0,
    /** French language */
    GHFrench = 1,
    /** Italian language */
    GHItalian = 2,
    /** German language */
    GHGerman = 3,
    /** Spanish language */
    GHSpanish = 4,
    /** Croatian language */
    GHCroatian = 5,
    /** Czech language */
    GHCzech = 6,
    /** Danish language */
    GHDanish = 7,
    /** Dutch language */
    GHDutch = 8,
    /** Finnish language */
    GHFinnish = 9,
    /** Greek language */
    GHGreek = 10,
    /** Hungarian language */
    GHHungarian = 11,
    /** Norwegian language */
    GHNorwegian = 12,
    /** Polish language */
    GHPolish = 13,
    /** Portuguese language */
    GHPortuguese = 14,
    /** Slovakian language */
    GHSlovakian = 15,
    /** Slovenian language */
    GHSlovenian = 16,
    /** Swedish language */
    GHSwedish = 17,
    /** Russian language */
    GHRussian = 18,
    /** Turkish language */
    GHTurkish = 19,
    /** Latvian language */
    GHLatvian = 20,
    /** Ukrainian language */
    GHUkrainian = 21,
    /** Arabic language */
    GHArabic = 22,
    /** Farsi language */
    GHFarsi = 23,
    /** Bulgarian language */
    GHBulgarian = 24,
    /** Romanian language */
    GHRomanian = 25,
    /** Chinese language */
    GHChinese = 26,
    /** Japanese language */
    GHJapanese = 27,
    /** Korean language */
    GHKorean = 28,
    /** Taiwanese language */
    GHTaiwanese = 29,
    /** Thai language */
    GHThai = 30,
    /** Hebrew language */
    GHHebrew = 31,
    /** Brazilian Portuguese language */
    GHBrazilianPortuguese = 32,
    /** Indonisian language */
    GHIndonesian = 33
};


#pragma mark -
/**
 *  The GHLanguage class provides available language settings for the Garmin device.
 */
@interface GHLanguage : NSObject <NSCoding, NSCopying>


/** ID number for the language */
@property (nonatomic, readonly) GHLanguageId identifier;

/** String representation of the language in English */
@property (nonatomic, readonly) NSString* displayName;

/** NS_UNAVAILABLE */
- (instancetype)init NS_UNAVAILABLE;


@end
